/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.mrp2;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import cz.insophy.inplan.mrp2.DefaultMaterialChangesCollector;
import cz.insophy.inplan.mrp2.DefaultSupplyFactory;
import cz.insophy.inplan.mrp2.Demand;
import cz.insophy.inplan.mrp2.GorSupply;
import cz.insophy.inplan.mrp2.MaterialChanges;
import cz.insophy.inplan.mrp2.MaterialChangesCollector;
import cz.insophy.inplan.mrp2.MaterialIncrementalMrpNamingStrategy;
import cz.insophy.inplan.mrp2.Pairing;
import cz.insophy.inplan.mrp2.PairingAlgorithm;
import cz.insophy.inplan.mrp2.PrDdSortKey;
import cz.insophy.inplan.mrp2.PrDdSortKeyExtractor;
import cz.insophy.inplan.mrp2.PrioPropertyTransferer;
import cz.insophy.inplan.mrp2.PropertyTransferer;
import cz.insophy.inplan.mrp2.SortedPairingAlgorithm;
import cz.insophy.inplan.mrp2.SrSupply;
import cz.insophy.inplan.mrp2.Supply;
import cz.insophy.inplan.mrp2.SupplyFactory;
import cz.insophy.inplan.shop.Product;
import cz.insophy.inplan.shop.ShopConfiguration;
import cz.insophy.inplan.superplan.GeneralizedOrderRequest;
import cz.insophy.inplan.superplan.GeneralizedRequest;
import cz.insophy.inplan.superplan.Superplan;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;

public class Mrp<PT> {
    protected final Superplan superplan;
    protected final ShopConfiguration conf;
    protected final MaterialChangesCollector materialChangesCollector;
    protected final SupplyFactory supplyFactory;
    protected final PairingAlgorithm pairingAlgorithm;
    protected final PropertyTransferer<PT> propertyTransferer;

    public Mrp(@Nonnull Superplan superplan, @Nonnull MaterialChangesCollector materialChangesCollector, @Nonnull PairingAlgorithm pairingAlgorithm, @Nonnull PropertyTransferer<PT> propertyTransferer, @Nonnull DefaultSupplyFactory supplyFactory) {
        this.superplan = Preconditions.checkNotNull(superplan);
        this.conf = superplan.getShopConf();
        this.materialChangesCollector = Preconditions.checkNotNull(materialChangesCollector);
        this.pairingAlgorithm = Preconditions.checkNotNull(pairingAlgorithm);
        this.propertyTransferer = Preconditions.checkNotNull(propertyTransferer);
        this.supplyFactory = Preconditions.checkNotNull(supplyFactory);
    }

    @Nonnull
    public static List<Supply> run(@Nonnull Superplan superplan) {
        return Mrp.run(superplan, ModifySuperplan.MODIFY);
    }

    @Nonnull
    public static List<Supply> run(@Nonnull Superplan superplan, @Nonnull ModifySuperplan modifySuperplan) {
        Mrp.fixGorDds(superplan);
        return new Mrp<PrioPropertyTransferer.Properties>(superplan, new DefaultMaterialChangesCollector(), new SortedPairingAlgorithm<PrDdSortKey>(new PrDdSortKeyExtractor()), new PrioPropertyTransferer(superplan), new DefaultSupplyFactory(superplan, new MaterialIncrementalMrpNamingStrategy(superplan))).run(modifySuperplan);
    }

    protected static void registerSupplies(@Nonnull Superplan superplan, @Nonnull List<Supply> supplies) {
        for (GorSupply gorSupply : Iterables.filter(supplies, GorSupply.class)) {
            superplan.addGor(gorSupply.getGor());
        }
        for (SrSupply srSupply : Iterables.filter(supplies, SrSupply.class)) {
            superplan.addSupplyRequest(srSupply.getSr());
        }
    }

    protected static void unregisterSupplies(@Nonnull Superplan superplan, @Nonnull List<Supply> supplies) {
        for (GorSupply gorSupply : Iterables.filter(supplies, GorSupply.class)) {
            superplan.removeGor(gorSupply.getGor());
        }
        for (SrSupply srSupply : Iterables.filter(supplies, SrSupply.class)) {
            superplan.removeSupplyRequest(srSupply.getSr());
        }
    }

    public static void fixGorDds(@Nonnull Superplan superplan) {
        for (GeneralizedOrderRequest gor : superplan.getGors()) {
            if (GeneralizedRequest.isDateValid(gor.getDueDate())) continue;
            gor.setDueDate(superplan.getFixationDate());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public List<Supply> run(@Nonnull ModifySuperplan modifySuperplan) {
        ArrayList<Supply> newSupplies = Lists.newArrayList();
        try {
            for (Product p : Lists.reverse(this.conf.getSortedProducts())) {
                MaterialChanges materialChanges = this.materialChangesCollector.collect(this.superplan, p);
                Pairing pairing = this.pairingAlgorithm.createPairing(materialChanges);
                List<Supply> supplies = pairing.completeSupplies(this.supplyFactory);
                this.transferProperties(pairing);
                newSupplies.addAll(supplies);
                Mrp.registerSupplies(this.superplan, supplies);
            }
        }
        finally {
            if (modifySuperplan == ModifySuperplan.DO_NOT_MODIFY) {
                Mrp.unregisterSupplies(this.superplan, newSupplies);
            } else {
                this.superplan.invalidateSDGraph();
            }
        }
        return newSupplies;
    }

    protected void transferProperties(@Nonnull Pairing pairing) {
        for (Supply supply : pairing.getAllSupplies()) {
            List<Demand> demands = pairing.getDemands(supply);
            ArrayList<PT> demandsProps = Lists.newArrayListWithCapacity(demands.size());
            for (Demand demand : demands) {
                demandsProps.add(demand.extractProperties(this.propertyTransferer));
            }
            supply.apply(this.propertyTransferer, demandsProps);
        }
    }

    @Nonnull
    protected String dumpPairing(@Nonnull Pairing pairing) {
        PrDdSortKeyExtractor ske = new PrDdSortKeyExtractor();
        StringBuilder sb = new StringBuilder();
        sb.append(pairing.getClass().getSimpleName());
        sb.append('\n');
        for (Supply supply : pairing.getAllSupplies()) {
            sb.append(" sup: ");
            sb.append(supply);
            sb.append(" sk=");
            sb.append(supply.getSortKey(ske));
            sb.append('\n');
            for (Demand demand : pairing.getDemands(supply)) {
                sb.append("  dem: ");
                sb.append(demand);
                sb.append(" props=");
                sb.append(demand.extractProperties(this.propertyTransferer));
                sb.append('\n');
            }
        }
        return sb.toString();
    }

    public static enum ModifySuperplan {
        MODIFY,
        DO_NOT_MODIFY;

    }
}

